import xbmc, xbmcgui, xbmcvfs, json, requests

URL_JSON = "https://uck.st/splite_movies/master_list_1.json"
#
LOCAL_JSON = "special://home/addons/plugin.program.rdtplayer/resources/data/local_list_All/local_list_all.json"

def load_movie_list(use_local: bool):
    data = None
    if use_local:
        xbmc.log("[RDTools] User selected LOCAL JSON list All.", xbmc.LOGINFO)
        try:
            path = xbmcvfs.translatePath(LOCAL_JSON)
            f = xbmcvfs.File(path)
            content = f.read()
            f.close()
            data = json.loads(content) if content.strip() else []
        except Exception as e:
            xbmcgui.Dialog().ok("RD Tools", f"Failed to load local JSON list All:\n{e}")
            xbmc.log(f"[RDTools] Local JSON list All error: {e}", xbmc.LOGERROR)
    else:
        xbmc.log("[RDTools] User selected REMOTE JSON list All.", xbmc.LOGINFO)
        try:
            r = requests.get(URL_JSON, timeout=8)
            data = r.json() if r.ok else []
            if not r.ok:
                xbmcgui.Dialog().ok("RD Tools", f"Failed to load remote list All (HTTP {r.status_code})")
        except Exception as e:
            xbmcgui.Dialog().ok("RD Tools", f"Remote JSON list All failed:\n{e}")
            xbmc.log(f"[RDTools] Remote JSON list All error: {e}", xbmc.LOGERROR)
    return data or []
