# modules/index_loader.py

import requests

INDEX_URL = "https://uck.st/splite_movies/list_sorted/index.json"

_CACHE = None

def load_index():
    global _CACHE

    if _CACHE is not None:
        return _CACHE

    r = requests.get(INDEX_URL, timeout=6)
    r.raise_for_status()

    _CACHE = r.json()
    return _CACHE
