import xbmc, xbmcgui, xbmcvfs, json, requests

URL_JSON = "https://uck.st/splite_movies/list_sorted/lost_year_2024.json"
#
LOCAL_JSON = "special://home/addons/plugin.program.rdtplayer/resources/data/local_list_2024/local_list_all.json"

def load_movie_list(use_local: bool):
    data = None
    if use_local:
        xbmc.log("[RDTools] User selected LOCAL JSON list 2024.", xbmc.LOGINFO)
        try:
            path = xbmcvfs.translatePath(LOCAL_JSON)
            f = xbmcvfs.File(path)
            content = f.read()
            f.close()
            data = json.loads(content) if content.strip() else []
        except Exception as e:
            xbmcgui.Dialog().ok("RD Tools", f"Failed to load local JSON list 2024:\n{e}")
            xbmc.log(f"[RDTools] Local JSON list 2024 error: {e}", xbmc.LOGERROR)
    else:
        xbmc.log("[RDTools] User selected REMOTE JSON list 2024.", xbmc.LOGINFO)
        try:
            r = requests.get(URL_JSON, timeout=8)
            data = r.json() if r.ok else []
            if not r.ok:
                xbmcgui.Dialog().ok("RD Tools", f"Failed to load remote list 2024 (HTTP {r.status_code})")
        except Exception as e:
            xbmcgui.Dialog().ok("RD Tools", f"Remote JSON list 2024 failed:\n{e}")
            xbmc.log(f"[RDTools] Remote JSON list 2024 error: {e}", xbmc.LOGERROR)
    return data or []
