# -*- coding: utf-8 -*-
import sys, json, requests, urllib.parse
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
from modules.rd_auth_unified import get_rd_headers
from modules import rdmagnet_importer
from modules import list_loader_w3  # W3-variant loader
# NOTE: no rd_auth_shared imports

ADDON_ID = "plugin.program.rdtplayer"
ADDON = xbmcaddon.Addon(id=ADDON_ID)
BASE_URL = "https://api.real-debrid.com/rest/1.0"
HANDLE = int(sys.argv[1])

#from modules.art_helper import get_artwork

from modules.rd_cloud_handler import add_to_cloud

def build_movie_directory():
    try:
        use_local = True  # FORCE LOCAL MODE for W3
        data = list_loader_w3.load_movie_list(use_local)
        xbmcgui.Dialog().notification("RD Tools",
                                                              "Loaded from year JSON List",
                                                              xbmcgui.NOTIFICATION_INFO, 2000)
    except Exception as e:
            xbmcgui.Dialog().ok("RD Tools", f"Error loading year JSON List:\n{e}")
            return

    if not data:
        xbmcgui.Dialog().ok("RD Tools", "No movies found.")
        return

    xbmcplugin.setContent(HANDLE, "movies")
    for movie in data:
        title = movie.get("title", "Untitled")
        magnet = movie.get("magnet", "")
        plot = movie.get("plot", "")
        poster = movie.get("poster", "")
        fanart = movie.get("fanart", "")
        year = movie.get("year", "")
        genre = movie.get("genre", "")
        runtime = movie.get("runtime", "")
        rated = movie.get("rated", "")
        certification = movie.get("certification", "")
        rating = movie.get("rating", "")
        imdb_rating = movie.get("imdb_rating", "")
    
        # 💎 Gold + Bold title
#        display_title = f"[COLOR gold][B]{title}[/B][/COLOR]"
        display_title = f"[COLOR white]{title}[/COLOR]"
    
        li = xbmcgui.ListItem(label=display_title)
        li.setInfo("video", {
            "title": display_title,
            "plot": plot,
            "year": year,
            "genre": genre,
            "duration": runtime,
            "mpaa": certification,
            "rating": rating or imdb_rating,
            "mediatype": "movie"
        })
        li.setArt({
            "thumb": poster, "poster": poster, "icon": poster, "fanart": fanart,
            "clearlogo": movie.get("clearlogo", ""), "banner": movie.get("banner", "")
        })
        li.setProperty("IsPlayable", "true")
    
        url = f"plugin://{ADDON_ID}/?action=add_to_cloud&title={urllib.parse.quote(title)}&magnet={urllib.parse.quote(magnet)}"
        xbmcplugin.addDirectoryItem(HANDLE, url, li, isFolder=False)
    
    xbmcplugin.endOfDirectory(HANDLE)

def router(paramstring):
    params = dict(urllib.parse.parse_qsl(paramstring))
    if params.get("action") == "add_to_cloud":
        add_to_cloud(params.get("title", ""), params.get("magnet", ""))
        return
    build_movie_directory()

if __name__ == "__main__":
    router(sys.argv[2][1:])
